<?php
// session_start();
// if ($_SESSION['role'] || $_SESSION['role'] != 'DFA') {
//     // Redirect to an unauthorized page if the role doesn't match
//     header('Location: unauthorized.php');
//     exit();
// }


include '../../backend/scripts/config.php';

// Fetch data
$sql = "SELECT * FROM card_tbl WHERE status = 'Verified-Accepted'";
$cards = $conn->query($sql);



$conn->close();
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="shortcut icon" href="./AIT_CREST.png" type="image/x-icon">
    <title>IDU</title>
</head>

<body>
    <div>
        <div class=' bg-white grid grid-cols-4 h-full   '>
            <div>
                <div class='grid-cols-1 fixed'>
                    <div class='w-full h-[80px] bg-white drop-shadow-xl z-50 fixed top-0'>
                        <div class='px-2 flex justify-between fdefs-center w-full h-full'>
                            <div class=' items-start'>
                                <h1 class=' inline-flex items-center'>
                                    <img src='../src/AIT_CREST.png' alt='crest' class=' h-16 w-16' />
                                </h1>
                            </div>

                            <p class=' pt-4 text-center lg:text-3xl font-bold '>AIT MARKETPLACE</p>

                            <div class='my-6'>
                                <Bars3Icon class='w-7 font-extrabold flex mx-5 lg:hidden' />
                            </div>
                        </div>
                    </div>
                </div>


                <!-- <IDLpane class='col-span-2' /> -->
                <nav class=' z-10 mt-24 h-screen left-0 fixed '>
                    <div class='h-screen bg-gray-900 drop-shadow-md rounded w-[70%]'>

                        <ul class=' text-white px-4 cursor-pointer '>
                            <li class=' py-5 border-gray-500 border-b-2'>
                                <a href="./AdminCardUnit.php">
                                    <DashboardIcon fontSize='large' class=' pr-3' />
                                    ALL REQUESTS
                                </a>
                            </li>

                            <li class=' py-5 border-gray-500 border-b-2 ' to="/cardrenewal">
                                <a href="AdminCardApproved.php">
                                    <CreditCardIcon fontSize='large' class=' pr-3' />
                                    APPROVED REQUESTS
                                </a>
                            </li>

                            <li class=' py-5 border-gray-500'>
                                <a href="./AdminCardRejected.php">
                                    <CardMembershipRounded fontSize='large' class=' pr-2' />
                                    REJECTED REQUESTS
                                </a>
                            </li>
                        </ul>

                        {/* LOGOS FOR FAQs OR POSING QUESTIONS */}
                        <div class=' hidden'>
                            <ul class=' inline-flex'>
                                <li>
                                    <ChatBubbleLeftIcon class='text-white w-12' />
                                </li>
                                <li>
                                    <HomeIcon class='text-white w-12' />
                                </li>
                                <li>
                                    <TicketIcon class='text-white w-10' />
                                </li>
                                <li>
                                    <UserIcon class='text-white w-12' />
                                </li>
                                <li>
                                    <UserGroupIcon class='text-white w-12' />
                                </li>
                                <li>
                                    <BoltIcon class='text-white w-12' />
                                </li>
                            </ul>
                        </div>
                    </div>

                </nav>



            </div>


            <div class='mt-24 grid col-span-8 col-start-2 w-full'>
                <div class=' m-6'>
                    <!-- {showAlert && (
                        <Alert variant="filled" severity={alertSeverity} onClose={() => setShowAlert(false)}>
                            {alertMessage}
                        </Alert>
                    )} -->
                </div>
                <div class='my-12 drop-shadow-md mr-12'>
                    <h1 class=' text-2xl font-semibold text-center bg-sky-800 text-white p-6 '> Card Requests</h1>
                    <table class=' overflow-y-auto drop-shadow-md w-full border-1 table table-striped text-sm'
                        id="example">
                        <th class=' text-center'>
                            <tr class="  text-center">
                                <th class=' border p-2'></th>
                                <th class=' border p-2'>ID NO.</th>
                                <th class=' border p-2'>CAMPUS</th>
                                <th class=' border p-2'>SERVICE</th>
                                <th class=' border p-2'>TRACKING ID</th>
                                <th class=' border p-2'>Status</th>
                                <th class=' border grid grid-cols-2 p-2'>ACTION
                                </th>
                            </tr>
                        </th>


                        <tbody class=' text-center w-full'>
                            <?php $count = 1;
                            while ($card = $cards->fetch_assoc()): ?>
                                <tr>
                                    <td class=" font-semibold"><?php echo $count ?></td>
                                    <td class="border"><?php echo $card['stuid'] ?></td>
                                    <td class="border"><?php echo $card['rqst_id'] ?></td>
                                    <td class="border"><?php echo $card['email'] ?></td>
                                    <td class="border"><?php echo $card['campus'] ?></td>
                                    <td class="border"><?php echo $card['service'] ?></td>
                                    <td class="border text-blue-700 gap-3">
                                        <a href="
                                    <?php
                                    $path = $card['image'];
                                    $tmp = substr($path, 0);
                                    $new_path = '../../backend/uploads/' . $tmp;
                                    echo $new_path;
                                    ?>" class=" text-blue-500 hover:text-red-500"><?php echo "View"; ?></a>

                                        <button data-id="<?php echo $card['rqst_id'] ?>"
                                            class="btn btn-success dfaCardapprove">Approve</button>

                                        <!-- <button type="button" class="btn btn-danger shadow-md" data-bs-toggle="modal"
                                            data-bs-target="#myModal">
                                            Reject
                                        </button> -->
                                        <button type="button" class="btn btn-danger shadow-md" data-bs-toggle="modal"
                                            data-bs-target="#myModal" data-id="<?php echo $card['rqst_id'] ?>"
                                            data-email="<?php echo $card['email'] ?>">
                                            Reject
                                        </button>
                                    </td>
                                </tr>
                                <?php $count++; endwhile ?>
                        </tbody>

                        <tfoot>
                        <tr class="  text-center">
                                <th class=' border p-2'></th>
                                <th class=' border p-2'>ID NO.</th>
                                <th class=' border p-2'>CAMPUS</th>
                                <th class=' border p-2'>SERVICE</th>
                                <th class=' border p-2'>TRACKING ID</th>
                                <th class=' border p-2'>Status</th>
                                <th class=' border grid grid-cols-2 p-2'>ACTION
                                </th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>




            <div class="modal" id="myModal">
                <div class="modal-dialog">
                    <div class="modal-content">

                        <!-- Modal Header -->
                        <Modal hideBackdrop open={open} onClose={handleClose} aria-labelledby="child-modal-title"
                            aria-describedby="child-modal-description">
                            <div>
                                <h2 id="child-modal-title" class=' text-center text-2xl font-bold p-6'>ID Card
                                    Renewal</h2>
                                <hr class=' shadow-3xl' />
                                <div id="child-modal-description">
                                    <form method="POST" id="rejectionForm" class="p-4">
                                        <textarea id="rejectionReason" rows="4" name="reason" class="form-control mb-4"
                                            placeholder="Enter reason for rejection..."></textarea>
                                        <button type="button" class="btn btn-secondary"
                                            data-bs-dismiss="modal">Close</button>
                                        <button type="button" class="btn btn-primary dfaCardReject"
                                            id="submitReject">Submit</button>
                                        <input type="hidden" id="requestId" name="requestId">
                                        <input type="hidden" id="requestEmail" name="requestEmail">
                                    </form>
                                </div>
                            </div>
                        </Modal>

                    </div>
                </div>
            </div>


        </div>

        <!-- {/* <div class=' col-span-4'></div> */} -->

    </div>
</body>
<script>
    $('#example').DataTable();


    $(".dfaCardapprove").click(function (e) {
        e.preventDefault();
        let id = $(this).data('id');

        $.ajax({
            type: "post",
            url: "../../backend/scripts/ajax.php?action=dfaCardApprove&id=" + id,
            success: function (response) {
                // alert(response);
                location.reload();
                // if (response == 1) {
                //     alert('ID HAS BEEN VERIFIED')
                //     location.reload();
                // } else {
                //     console.log("Failed to approve: ", response);
                // }
            },
            // error: function (xhr, status, error) {
            //     console.error("AJAX Error: ", status, error);
            // }
        });
    });

    // $("#rejectionForm").on(events, function () {

    //     e.preventDefault();
    //     let reason = $("#rejectionReason").val();

    //     let id = $(this).data('rqst_id');

    //     $.ajax({
    //         type: "post",
    //         url: "../../backend/scripts/ajax.php?action=dfaCardReject&id=" + id,
    //         success: function (response) {
    //             // alert(response)
    //             // if (response == 1) {
    //             //     alert('ID HAS BEEN REJECTED')
    //             location.reload();
    //             //     } else {
    //             //         console.log("Failed to approve: ", response);
    //             //     }
    //         },
    //         // error: function (xhr, status, error) {
    //         //     console.error("AJAX Error: ", status, error);
    //         // }
    //     });
    // });


    document.addEventListener('DOMContentLoaded', function () {
        var id = "";
        var reason = "";
        var email = "";
        var myModal = document.getElementById('myModal');
        myModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget; // Button that triggered the modal
            var requestId = button.getAttribute('data-id'); // Extract info from data-* attributes
            var requestEmail = button.getAttribute('data-email');
            var modal = this;
            modal.querySelector('#requestId').value = requestId;
        });

        document.getElementById('rejectionForm').addEventListener('mouseover', function () {
            reason = document.getElementById('rejectionReason').value;
            id = document.getElementById('requestId').value;
            email = document.getElementById('requestEmail').value;
            // alert(id)

        });

        document.getElementById('rejectionReason').addEventListener('focus', function () {
            reason = document.getElementById('rejectionReason').value;
            id = document.getElementById('requestId').value;
            email = document.getElementById('requestEmail').value;
            // alert(id)

        });

        $("#submitReject").on("click", function (e) {
            e.preventDefault();

            $.ajax({
                url: '../../backend/scripts/ajax.php?action=dfaCardReject&id=' + id + "&reason=" + reason + "&email=" + email,
                success: function (response) {
                    // if (response == 1) {
                    //     alert('Request rejected and email sent successfully.');
                    //     // $('#myModal').modal('hide');
                    // } else {
                    //     alert(response); // Display the detailed error message from PHP
                    // }



                    alert(response);
                    location.reload();
                },
                error: function () {
                    alert('Error in AJAX request.');
                }
            });
        });
    });



</script>


</html>