<?php
// session_start();
// if ($_SESSION['role'] != 'DFA') {
//     // Redirect to an unauthorized page if the role doesn't match
//     header('Location: unauthorized.php');
//     exit();
// }


include '../../backend/scripts/config.php';

// Fetch data
$sql = "SELECT * FROM card_tbl WHERE status = 'Verified-Accepted'";
$cards = $conn->query($sql);


$conn->close();
?>




<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="shortcut icon" href="../src/AIT_CREST.png" type="image/x-icon">
    <title>ID Card Renewal </title>
    <link rel="stylesheet" href="https://cdn.datatables.net/2.0.7/css/dataTables.bootstrap5.css">


</head>


<style>
    /* Hide the dropdown by default */
    .dropsdown {
        display: none;
    }

    /* Show the dropdown when the parent <li> is hovered over */
    li:hover .dropsdown {
        display: block;
    }
</style>



<body>
    <Mo class=' bg-white h-full relative'>
        <div>
            <!-- <Navbar /> -->
            <div class='w-full h-[80px] bg-white drop-shadow-xl z-50 fixed top-0'>
                <div class='px-2 flex justify-between fdefs-center w-full h-full'>
                    <div class=' items-start'>
                        <h1 class=' inline-flex items-center'>
                            <img src='../src/AIT_CREST.png' alt='crest' class=' h-16 w-16' />
                        </h1>
                    </div>

                    <p class=' pt-4 text-center lg:text-3xl font-bold '>AIT MARKETPLACE</p>

                    <div class='my-6'>
                        <Bars3Icon class='w-7 font-extrabold flex mx-5 lg:hidden' />
                    </div>
                </div>
            </div>



            <nav class=' z-10 mt-24 h-screen left-0 w-[15%] fixed '>
        <div class='h-screen bg-gray-900 drop-shadow-md rounded'>

            <ul class=' text-white cursor-pointer'>
                <li class=' border-gray-500 border-b-2'>
                    <a href="./AdminDash.php">
                        <p class="p-4">DASHBOARD</p>
                    </a>
                </li>

                <li class='border-gray-500 border-b-2'>
                    <a href="./AdminCardRenewal.php">
                        <p class="p-4">ID CARD RENEWALS</p>
                    </a>
                    <div class="dropsdown p-2 bg-gray-700 w-full">
                        <a href="./DFACardVerifiedApp.php">
                            <div class="p-2 hover:text-blue-500">Approved Requests</div>
                        </a>
                        <a href="./DFACardVerifiedRej.php">
                            <div class="p-2 hover:text-blue-500">Rejected Requests</div>
                        </a>
                    </div>
                </li>

                <li class='border-gray-500 border-b-2'>
                    <a href="./AdminTranscript.php">
                        <p class="p-4">TRANSCRIPT APPLICATIONS</p>
                        <div class="dropsdown p-2 bg-gray-700 w-full">
                            <a href="./DFATransApp.php">
                                <div class="p-2 hover:text-blue-500">Approved Requests</div>
                            </a>

                            <a href="./DFATransRej.php">
                                <div class="p-2 hover:text-blue-500">Rejected Requests</div>
                            </a>

                        </div>
                    </a>
                </li>


                <li class='border-gray-500 border-b-2'>
                    <a href="./AdminCertificate.php">
                        <p class="p-4">CERTIFICATE APPLICATION</p>
                    </a>
                    <div class="dropsdown p-2 bg-gray-700 w-full">
                        <a href="./DFACertApp.php">
                            <div class="p-2 hover:text-blue-500">Approved Requests</div>
                        </a>
                        <a href="./DFACertRej.php">
                            <div class="p-2 hover:text-blue-500">Rejected Requests</div>
                        </a>
                    </div>

                </li>

                <li class='border-gray-500 border-b-2'>
                    <a href="./AdminDeferment.php">
                        <p class="p-4">DEFERMENT APPLICATION</p>
                    </a>
                    <div class="dropsdown p-2 bg-gray-700 w-full">
                        <a href="./DFADeferApp.php">
                            <div class="p-2 hover:text-blue-500">Approved Requests</div>
                        </a>
                        <a href="./DFADeferRej.php">
                            <div class="p-2 hover:text-blue-500">Rejected Requests</div>
                        </a>



                    </div>

                </li>

                <li class='border-gray-500 border-b-2'>
                    <a href="AdminIntroductory.php">
                        <p class="p-4">INTRODUCTORY LETTER</p>
                    </a>
                    <div class="dropsdown p-2 bg-gray-700 w-full">
                        <a href="./DFAIntroApp.php">
                            <div class="p-2 hover:text-blue-500">Approved Requests</div>
                        </a>

                        <a href="./DFAIntroRej.php">
                            <div class="p-2 hover:text-blue-500">Rejected Requests</div>
                        </a>

                    </div>
                </li>

                <!-- <li class='border-gray-500 border-b-2'>
                            <a href="#">
                                <p class="p-4">SETTINGS</p>
                            </a>
                            <div class="dropsdown p-2 bg-gray-700 w-full">
                                <div class="p-2 hover:text-blue-500">Approved Requests</div>
                                <div class="p-2 hover:text-blue-500">Rejected Requests</div>
                            </div>
                        </li> -->
            </ul>
        </div>

    </nav>
        </div>


        <div class='grid grid-cols-9'>
            <div class='mt-24 grid col-span-8 col-start-3 w-[95%]'>
                <div class=' col-span-full grid'>

                    <div class=' col-span-4'></div>
                    <div class=' col-span-3 m-2'>
                    </div>
                </div>



                <Card class='my-12 drop-shadow-sm'>
                    <h1 class=' text-white text-2xl font-semibold text-center w-full bg-green-800 p-6 rounded-lg'>Financially Cleared Card Renewal
                        Requests</h1>
                    <table class=' overflow-y-auto drop-shadow-md w-full border-1 table table-striped text-xs'
                        id="example">


                        <thead class=" text-center">
                            <tr>
                                <th class=" text-center border p-2">SN</th>
                                <th class=" font-bold border p-2 text-center">ID NO.</th>
                                <th class=" font-bold border p-2 text-center">REQUEST ID</th>
                                <th class=" font-bold border p-2 text-center">EMAIL</th>
                                <th class=" font-bold border p-2 text-center">CAMPUS</th>
                                <th class=" font-bold border p-2 text-center">SERVICE</th>

                            </tr>

                        </thead>

                        <tbody class=' text-center w-full'>
                            <?php $count = 1;
                            while ($card = $cards->fetch_assoc()): ?>
                                <tr>
                                    <td class=" font-semibold"><?php echo $count ?></td>
                                    <td class="border"><?php echo $card['stuid'] ?></td>
                                    <td class="border"><?php echo $card['rqst_id'] ?></td>
                                    <td class="border"><?php echo $card['email'] ?></td>
                                    <td class="border"><?php echo $card['campus'] ?></td>
                                    <td class="border"><?php echo $card['service'] ?></td>
                                    <!-- <td class="border text-blue-700 gap-3">
                                        <a href="
                                    <?php
                                    $path = $card['image'];
                                    $tmp = substr($path, 0);
                                    $new_path = '../../backend/uploads/' . $tmp;
                                    echo $new_path;
                                    ?>" class=" text-blue-500 hover:text-red-500"><?php echo "View"; ?></a>

                                        <button data-id="<?php echo $card['rqst_id'] ?>"
                                            class="btn btn-success dfaCardapprove">Approve</button>
                                        <button type="button" class="btn btn-danger shadow-md" data-bs-toggle="modal"
                                            data-bs-target="#myModal" data-id="<?php echo $card['rqst_id'] ?>"
                                            data-email="<?php echo $card['email'] ?>">
                                            Reject
                                        </button>
                                    </td> -->
                                </tr>
                                <?php $count++; endwhile ?>
                        </tbody>



                        <tfoot>
                            <tr>
                                <th class=" text-center border p-2">SN</th>
                                <th class=" font-bold border p-2 text-center">ID NO.</th>
                                <th class=" font-bold border p-2 text-center">REQUEST ID</th>
                                <th class=" font-bold border p-2 text-center">EMAIL</th>
                                <th class=" font-bold border p-2 text-center">CAMPUS</th>
                                <th class=" font-bold border p-2 text-center">SERVICE</th>

                            </tr>
                        </tfoot>

                    </table>
                </Card>
            </div>

        </div>




        <div class="modal" id="myModal">
            <div class="modal-dialog">
                <div class="modal-content">

                    <!-- Modal Header -->
                    <Modal hideBackdrop open={open} onClose={handleClose} aria-labelledby="child-modal-title"
                        aria-describedby="child-modal-description">
                        <div>
                            <h2 id="child-modal-title" class=' text-center text-2xl font-bold p-6'>ID Card
                                Renewal</h2>
                            <hr class=' shadow-3xl' />
                            <div id="child-modal-description">
                                <form method="POST" id="rejectionForm" class="p-4">
                                    <center>
                                        <label for="rejectionReason" class="text-lg font-bold center pb-6"> Enter the
                                            reason(s) for Request Rejection</label>
                                    </center>
                                    <textarea id="rejectionReason" rows="4" name="reason" class="form-control mb-4"
                                        placeholder="This request is being rejected because..." required></textarea>
                                    <!-- <button type="button" class="btn btn-secondary"
                                        data-bs-dismiss="modal">Close</button> -->

                                    <center>
                                        <button type="button" class="btn btn-primary dfaCardReject center"
                                            id="submitReject">Send Message</button>
                                    </center>

                                    <input type="hidden" id="requestId" name="requestId">
                                    <input type="hidden" id="requestEmail" name="requestEmail">
                                </form>
                            </div>
                        </div>
                    </Modal>

                </div>
            </div>
        </div>
        </div>
        </div>

        <div>





            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>



            <script src="https://code.jquery.com/jquery-3.7.1.min.js"
                integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
            <script
                src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
            <script src="https://cdn.datatables.net/2.0.7/js/dataTables.js"></script>
            <script src="https://cdn.datatables.net/2.0.7/js/dataTables.bootstrap5.js"></script>

            <script>
                $('#example').DataTable();


                $(".dfaCardapprove").click(function (e) {
                    e.preventDefault();
                    let id = $(this).data('id');

                    $.ajax({
                        type: "post",
                        url: "../../backend/scripts/ajax.php?action=dfaCardApprove&id=" + id,
                        success: function (response) {
                            // alert(response);
                            location.reload();

                        },

                    });
                });


                document.addEventListener('DOMContentLoaded', function () {
                    var id = "";
                    var reason = "";
                    var email = "";
                    var myModal = document.getElementById('myModal');
                    myModal.addEventListener('show.bs.modal', function (event) {
                        var button = event.relatedTarget; // Button that triggered the modal
                        var requestId = button.getAttribute('data-id'); // Extract info from data-* attributes
                        var requestEmail = button.getAttribute('data-email');
                        var modal = this;
                        modal.querySelector('#requestId').value = requestId;
                    });

                    document.getElementById('rejectionForm').addEventListener('mouseover', function () {
                        reason = document.getElementById('rejectionReason').value;
                        id = document.getElementById('requestId').value;
                        email = document.getElementById('requestEmail').value;
                        // alert(id)

                    });

                    document.getElementById('rejectionReason').addEventListener('focus', function () {
                        reason = document.getElementById('rejectionReason').value;
                        id = document.getElementById('requestId').value;
                        email = document.getElementById('requestEmail').value;
                        // alert(id)

                    });

                    $("#submitReject").on("click", function (e) {
                        e.preventDefault();

                        $.ajax({
                            url: '../../backend/scripts/ajax.php?action=dfaCardReject&id=' + id + "&reason=" + reason + "&email=" + email,
                            success: function (response) {

                                alert(response);
                                location.reload();
                            },
                            error: function () {
                                alert('Error in AJAX request.');
                            }
                        });
                    });
                });



            </script>

</body>

</html>