<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.25/css/jquery.dataTables.min.css">

    <!-- DataTables JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>

    <!-- FileSaver.js (for CSV export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/FileSaver.js/2.0.5/FileSaver.min.js"></script>
    <title>Document</title>
</head>




<style>
    .buttons {
        margin-bottom: 10px;
    }

    .buttons button {
        margin-right: 10px;
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    th, td {
        border: 1px solid #ddd;
        padding: 8px;
    }

    th {
        background-color: #f4f4f4;
    }
</style>

<body>
    <div class="container">
        <!-- Buttons for Print and CSV -->
        <div class="buttons">
            <button id="printButton">Print</button>
            <button id="csvButton">Export CSV</button>
        </div>

        <!-- Table -->
        <table id="example" class="display" style="width:100%">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Position</th>
                    <th>Office</th>
                    <th>Age</th>
                    <th>Start date</th>
                    <th>Salary</th>
                </tr>
            </thead>
            <tbody>
                <!-- Data rows go here -->
            </tbody>
        </table>
    </div>


</body>
<script>
    $(document).ready(function() {
    var table = $('#example').DataTable();

    // Print button functionality
    $('#printButton').on('click', function() {
        var printWindow = window.open('', '', 'height=600,width=800');
        printWindow.document.write('<html><head><title>Print Table</title>');
        printWindow.document.write('</head><body >');
        printWindow.document.write('<h1>Table Data</h1>');
        printWindow.document.write($('#example').parent().html());
        printWindow.document.write('</body></html>');
        printWindow.document.close();
        printWindow.focus();
        printWindow.print();
    });

    // CSV button functionality
    $('#csvButton').on('click', function() {
        var csv = [];
        var rows = document.querySelectorAll('#example tr');
        
        for (var i = 0; i < rows.length; i++) {
            var row = [], cols = rows[i].querySelectorAll('td, th');
            
            for (var j = 0; j < cols.length; j++) 
                row.push(cols[j].innerText);
            
            csv.push(row.join(','));
        }

        var csvFile;
        var downloadLink;

        csvFile = new Blob([csv.join('\n')], { type: 'text/csv' });

        downloadLink = document.createElement("a");

        downloadLink.download = "data-table.csv";
        downloadLink.href = window.URL.createObjectURL(csvFile);
        downloadLink.style.display = "none";
        document.body.appendChild(downloadLink);

        downloadLink.click();
    });
});

</script>

</html>