
<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stuid = $_POST['stuid'];
    $rqst_id = $_POST['rqst_id'];


    $host = 'localhost';
    $dbname = 'requests';
    $username = 'root';
    $password = '';
    

    try {
        // Establish PDO connection
        $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    } catch (PDOException $e) {
        die("Could not connect to the database $dbname: " . $e->getMessage());
    }

    // Define the SQL query to get the status
    $sql = "
        SELECT 'card_tbl' AS table_name, status FROM card_tbl WHERE stuid = :stuid AND rqst_id = :rqst_id
        UNION ALL
        SELECT 'tbl_deferments' AS table_name, status FROM tbl_deferments WHERE stuid = :stuid AND rqst_id = :rqst_id
        UNION ALL
        SELECT 'tbl_introductory_requests' AS table_name, status FROM tbl_introductory_requests WHERE stuid = :stuid AND rqst_id = :rqst_id
        UNION ALL
        SELECT 'tbltranscript_requests' AS table_name, status FROM tbltranscript_requests WHERE stuid = :stuid AND rqst_id = :rqst_id
    ";

    // Prepare the SQL statement
    $stmt = $pdo->prepare($sql);

    // Bind parameters
    $stmt->bindParam(':stuid', $stuid, PDO::PARAM_STR); // Changed to PDO::PARAM_STR if IDs are alphanumeric
    $stmt->bindParam(':rqst_id', $rqst_id, PDO::PARAM_STR); // Changed to PDO::PARAM_STR if IDs are alphanumeric

    // Execute the statement
    $stmt->execute();

    // Fetch the result
    $request = $stmt->fetch(PDO::FETCH_ASSOC);

    // Define the possible states
    $states = ['Pending', 'Verified', 'Approved', 'Done'];

    // Determine the current state
    $current_state = $request ? $request['status'] : 'Request does not exist';

    // Find the index of the current state in the states array
    $current_index = array_search($current_state, $states);

    // Prepare the stepper HTML
    ob_start(); // Start output buffering
    ?>
    <?php if ($current_state === 'Request does not exist'): ?>
        <p id="status-text">Request does not exist</p>
    <?php else: ?>
        <div class="stepper">
            <?php foreach ($states as $index => $state): ?>
                <div class="step <?= $index <= $current_index ? 'completed' : '' ?>">
                    <div class="circle"><?= $index + 1 ?></div>
                    <div><?= $state ?></div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
    <?php
    $stepperHtml = ob_get_clean(); // Get the buffer contents and clean the buffer

    // Return JSON response
    echo json_encode(['status' => 'success', 'stepperHtml' => $stepperHtml]);
}
?>
