<?php

$host = 'localhost';
$dbname = 'requests';
$username = 'root';
$password = '';



// Create a new PDO instance\\C);

try {
    // Establish PDO connection
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Could not connect to the database $dbname: " . $e->getMessage());
}

// Define the SQL query
$sql = "
    SELECT 'card_tbl' AS table_name, status FROM card_tbl WHERE stuid = :stuid AND rqst_id = :rqst_id
    UNION ALL
    SELECT 'tbl_deferments' AS table_name, status FROM tbl_deferments WHERE stuid = :stuid AND rqst_id = :rqst_id
    UNION ALL
    SELECT 'tbl_introductory_requests' AS table_name, status FROM tbl_introductory_requests WHERE stuid = :stuid AND rqst_id = :rqst_id
    UNION ALL
    SELECT 'tbltranscript_requests' AS table_name, status FROM tbltranscript_requests WHERE stuid = :stuid AND rqst_id = :rqst_id
";

// Prepare the SQL statement
$stmt = $pdo->prepare($sql);

// Bind parameters
$stmt->bindParam(':stuid', $stuid, PDO::PARAM_INT);
$stmt->bindParam(':rqst_id', $request_id, PDO::PARAM_INT);

// Execute the statement
$stmt->execute();

// Fetch the result
$request = $stmt->fetch(PDO::FETCH_ASSOC);

print_r($request);

// Define the states
$states = ['Pending', 'Verified-Accepted', 'Approved', 'Done'];

// Check if the request exists and get the status
if ($request) {
    $current_state = $request['status'];
} else {
    $current_state = 'Request does not exist';
}

// Find the index of the current state in the states array
$current_index = array_search($current_state, $states);

if ($current_state === 'Request does not exist') {
    echo "<script>console.log('Request does not exist');</script>";
}
?>





<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@mui/material@5.8.7/dist/material.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .stepper {
            display: flex;
            justify-content: space-between;
            margin: 20px 0;
        }

        .step {
            text-align: center;
            flex: 1;
            position: relative;
        }

        .step::before {
            content: "";
            position: absolute;
            top: 50%;
            left: 0;
            width: 100%;
            height: 2px;
            background-color: #ccc;
            z-index: -1;
        }

        .step:first-child::before {
            left: 50%;
            width: 50%;
        }

        .step:last-child::before {
            width: 50%;
        }

        .step.completed .circle {
            background-color: #4caf50;
            color: #fff;
        }

        .step .circle {
            display: inline-block;
            width: 40px;
            height: 40px;
            line-height: 40px;
            border-radius: 50%;
            background-color: #ccc;
            color: #000;
        }
    </style>
    <title>Track or Make a Request</title>
</head>

<body>
    <div>
        <div class='grid lg:grid-cols-2 h-screen sm:flex-1'>
            <!-- {/* New Request card */} -->
            <!-- {/* <div class='grid-cols-1 bg-slate-200 pt-[20%] text-center' > */} -->

            <div class='flex items-center justify-center bg-slate-200 text-center '>
                <div class='bg-white outline-blue-500 md:w-[50%] m-auto rounded-2xl px-6 border-solid py-20'>

                    <img src='../src/AIT_CREST.png' alt='Logo' class='w-24 h-24 m-auto p-auto' />
                    <br />
                    <h1 class='font-bold text-lg'>NEW REQUEST</h1>
                    <div class='text-red-800 text-center text-xs pb-6'>
                        PLEASE MAKE SURE TO KEEP OR TAKE NOTE OF THE TRACKING ID GENERATED FOR YOUR REQUEST AFTER A
                        SUCCESSFUL
                        SUBMISSION. IT WOULD BE REQUIRED IN THE EVENT OF TRACKING YOUR REQUEST(S)'S STATUS
                    </div>
                    <a href='../Client/NewRequest.php'>
                        <button class=" btn btn-primary" variant='contained'>APPLY</button>
                    </a>
                </div>
            </div>

            <!-- {/* <div class='grid-cols-2 bg-blue-700 pt-[20%] text-center'> */} -->
            <div class='flex items-center justify-center bg-blue-700 text-center'>
                <div class='bg-white outline-blue-500 md:w-[50%] m-auto rounded-2xl px-6 border-solid py-12'>
                    <img src='../src/AIT_CREST.png' alt='Logo' class='w-24 h-24 m-auto p-auto' />
                    <br />
                    <!-- <h1 class='font-bold'>TRACK STATUS OF SINGLE REQUEST</h1>
                    <br /> -->


                    
                    <!-- <form id="statusForm" action="track_request.php">
                        <input placeholder='Enter Your ID Number' type='text' name='stuid'
                            class="border-1 border-black p-2 rounded-lg outline-blue-600" required />
                        <br /><br />
                        <input placeholder='Enter Request Tracking ID' type='text' name='rqst_id'
                            class="border-1 border-black p-2 rounded-lg outline-blue-600" required />
                        <br /><br />


                        <button type="submit" class="btn btn-primary shadow-md">
                            Submit
                        </button>

                        <p class='text-red-800 hover:text-blue-800 text-lg pt-4' data-bs-toggle="modal" data-bs-target="#myModal"> View History of
                            All Requests Made</p>

                    </form> -->

                    <form action="Activity.php" method="POST" id='activityForm'>
                                        <div>
                                            <label for="stuid" class="font-bold">To view your entire history of
                                                requests, enter your ID Number</label>
                                        </div>
                                        <div>
                                            <input type="text" name="stuid" id="stuid"
                                                class="border-1 border-black p-2 rounded-lg outline-blue-600">
                                        </div>
                                        <button type="submit" class="btn btn-primary mt-4"
                                            data-bs-dismiss="modal">Submit</button>
                                    </form>



                    <div class="modal fade" id="statusModal" tabindex="-1" aria-labelledby="statusModalLabel"
                        aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header text-center">
                                    <h5 class="modal-title" id="statusModalLabel">Request Status</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body" id="modalBody">

                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- The Modal -->
                    <div class="modal" id="myModal">
                        <div class="modal-dialog">
                            <div class="modal-content">

                                <!-- Modal Header -->
                                <div class="modal-header">
                                    <h4 class="modal-title text-center font-bold">REQUEST HISTORY FORM</h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>

                                <!-- Modal body -->
                                <div class="modal-body">
                                    <form action="Activity.php" method="POST" id='activityForm'>
                                        <div>
                                            <label for="stuid" class="font-bold">To view your entire history of
                                                requests, enter your ID Number</label>
                                        </div>
                                        <div>
                                            <input type="text" name="stuid" id="stuid"
                                                class="border-1 border-black p-2 rounded-lg outline-blue-600">
                                        </div>
                                        <button type="submit" class="btn btn-primary"
                                            data-bs-dismiss="modal">Submit</button>
                                    </form>
                                </div>

                                <!-- Modal footer -->
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-danger items-center"
                                        data-bs-dismiss="modal">Close</button>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- <script>
    $(document).ready(function () {
        $('#statusForm').submit(function (event) {
            event.preventDefault(); // Prevent default form submission

            $.ajax({
                url: '../../backend/scripts/check_status.php',
                type: 'POST',
                data: $(this).serialize(), // Send form data
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        // Update the modal with the response data
                        updateModal(response.status, response.activeStep);
                        // Show the modal
                        $('#myModal').modal('show');
                    } else {
                        alert('Error fetching status');
                    }
                },
                error: function () {
                    alert('An error occurred');
                }
            });
        });

        function updateModal(status, activeStep) {
            // Update modal content based on status and activeStep
            $('.step').removeClass('active'); // Remove active class from all steps
            $(`.step-${activeStep}`).addClass('active'); // Add active class to the correct step
            $('#status-text').text(status); // Set the status text
        }
    });
</script> -->

<script>
    $(document).ready(function () {
        $('#statusForm').on('submit', function (event) {
            event.preventDefault(); // Prevent the form from submitting normally

            var formData = $(this).serialize(); // Serialize the form data

            $.ajax({
                type: 'POST',
                url: 'track_request.php',
                data: formData,
                dataType: 'json',
                success: function (response) {
                    if (response.status === 'success') {
                        // Inject the stepper HTML into the modal body
                        $('#modalBody').html(response.stepperHtml);
                        // Show the modal
                        $('#statusModal').modal('show');
                    } else {
                        alert('Failed to retrieve status. Please try again.');
                    }
                },
                error: function () {
                    alert('An error occurred while processing your request.');
                }
            });
        });
    });





    $(document).ready(function () {
        $("#activityForm").on('submit', function (event) {
            event.preventDefault();

            const stuid = $("#stuid").val();
            // alert(userid);


            location.href="../../frontend/Client/Activity.php?stuid=" + stuid;

            // $.ajax({
            //     type: "POST",
            //     url: "../../frontend/Client/Activity.php",
            //     data: { stuid: userid },
            //     success: function (response) {
                    
            //         location.replace("../../frontend/Client/Activity.php");
            //         // You can update the page content with the fetched data here
            //     }
            // });


        });
    });


</script>

</html>