<?php
// session_start();
include '../../backend/scripts/config.php';
include '../../backend/scripts/semyear.php';

// Fetch data
$sql = "SELECT * FROM tbl_introductory_requests WHERE status = 'Verified-Rejected'";
$acdyear = "SELECT acdyr, sem FROM tblcurracdyr LIMIT 1";
$introductorys = $conn->query($sql);
$academicyear = $conn->query($acdyear);



$conn->close();
?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="shortcut icon" href="../src/AIT_CREST.png" type="image/x-icon">
    <title>Admin Introductory Requests</title>
</head>


<style>
    /* Hide the dropdown by default */
    .dropsdown {
        display: none;
    }

    /* Show the dropdown when the parent <li> is hovered over */
    li:hover .dropsdown {
        display: block;
    }
</style>



<body>
    <div class=' bg-white grid grid-cols-4 h-full   '>
        <div>
            <div class='w-full h-[80px] bg-white drop-shadow-xl z-50 fixed top-0'>
                <div class='px-2 flex justify-between fdefs-center w-full h-full'>
                    <div class=' items-start'>
                        <h1 class=' inline-flex items-center'>
                            <img src='../src/AIT_CREST.png' alt='crest' class=' h-16 w-16' />
                        </h1>
                    </div>

                    <p class=' pt-4 text-center lg:text-3xl font-bold '>AIT MARKETPLACE</p>

                    <div class='my-6'>
                        <Bars3Icon class='w-7 font-extrabold flex mx-5 lg:hidden' />
                    </div>
                </div>
            </div>


            <!-- <Lpane class='col-span-2' /> -->
            <nav class=' z-10 mt-24 h-screen left-0 w-[15%] fixed '>
                <div class='h-screen bg-gray-900 drop-shadow-md rounded'>

                    <ul class=' text-white cursor-pointer'>
                        <li class=' border-gray-500 border-b-2'>
                            <a href="./AdminDash.php">
                                <p class="p-4">DASHBOARD</p>
                            </a>
                        </li>

                        <li class='border-gray-500 border-b-2'>
                            <a href="./AdminCardRenewal.php">
                                <p class="p-4">ID CARD RENEWALS</p>
                            </a>
                            <div class="dropsdown p-2 bg-gray-700 w-full">
                                <a href="./DFACardVerifiedApp.php">
                                    <div class="p-2 hover:text-blue-500">Approved Requests</div>
                                </a>
                                <a href="./DFACardVerifiedRej.php">
                                    <div class="p-2 hover:text-blue-500">Rejected Requests</div>
                                </a>
                            </div>
                        </li>

                        <li class='border-gray-500 border-b-2'>
                            <a href="./AdminTranscript.php">
                                <p class="p-4">TRANSCRIPT APPLICATIONS</p>
                                <div class="dropsdown p-2 bg-gray-700 w-full">
                                    <a href="./DFATransApp.php">
                                        <div class="p-2 hover:text-blue-500">Approved Requests</div>
                                    </a>

                                    <a href="./DFATransRej.php">
                                        <div class="p-2 hover:text-blue-500">Rejected Requests</div>
                                    </a>

                                </div>
                            </a>
                        </li>


                        <li class='border-gray-500 border-b-2'>
                            <a href="./AdminCertificate.php">
                                <p class="p-4">CERTIFICATE APPLICATION</p>
                            </a>
                            <div class="dropsdown p-2 bg-gray-700 w-full">
                                <a href="./DFACertApp.php">
                                    <div class="p-2 hover:text-blue-500">Approved Requests</div>
                                </a>
                                <a href="./DFACertRej.php">
                                    <div class="p-2 hover:text-blue-500">Rejected Requests</div>
                                </a>
                            </div>

                        </li>

                        <li class='border-gray-500 border-b-2'>
                            <a href="./AdminDeferment.php">
                                <p class="p-4">DEFERMENT APPLICATION</p>
                            </a>
                            <div class="dropsdown p-2 bg-gray-700 w-full">
                                <a href="./DFADeferApp.php">
                                    <div class="p-2 hover:text-blue-500">Approved Requests</div>
                                </a>
                                <a href="./DFADeferRej.php">
                                    <div class="p-2 hover:text-blue-500">Rejected Requests</div>
                                </a>



                            </div>

                        </li>

                        <li class='border-gray-500 border-b-2'>
                            <a href="AdminIntroductory.php">
                                <p class="p-4">INTRODUCTORY LETTER</p>
                            </a>
                            <div class="dropsdown p-2 bg-gray-700 w-full">
                                <a href="./DFAIntroRej.php">
                                    <div class="p-2 hover:text-blue-500">Approved Requests</div>
                                </a>

                                <a href="./DFAIntroRej.php">
                                    <div class="p-2 hover:text-blue-500">Rejected Requests</div>
                                </a>

                            </div>
                        </li>
                    </ul>
                </div>

            </nav>
        </div>

        <div class='mt-24 grid col-span-8 col-start-2 w-[95%]'>
            <Card class='my-12'>
                <h1 class=' text-2xl font-semibold text-center bg-red-800 text-white p-6 '>Rejected Introductory Letter
                    Requests
                </h1>
                <table id="example" class='  overflow-y-auto drop-shadow-md w-full table table-striped text-xs'>
                    <thead class=' text-center w-full'>
                        <tr>
                            <th class=" text-bold border p-2" class=' border'>SN</th>
                            <th class=" text-bold border p-2" class=' border'>ID NO.</th>
                            <th class=" text-bold border p-2" class=' border'>REQUEST ID</th>
                            <th class=" text-bold border p-2" class=' border'>NAME</th>
                            <th class=" text-bold border p-2" class=' border'>PASSPORT NUMBER</th>
                            <th class=" text-bold border p-2" class=' border text-center'>E-MAIL</th>
                            <th class=" text-bold border p-2" class=' border text-center'>PHONE</th>
                            <th class=" text-bold border p-2" class=' border text-center'>PURPOSE</th>
                            <!-- <th class=" text-bold border p-2" class=' border text-center'>ACTION</th> -->
                        </tr>
                    </thead>

                    <tbody>
                        <?php $count = 1;
                        while ($introductory = $introductorys->fetch_assoc()): ?>
                            <tr class=' border p-12'>
                                <td> <?php echo $count ?></th>
                                <td class=' text-left p-3 border'><?php echo $introductory['stuid'] ?></td>
                                <td class=' text-left p-3 border'><?php echo $introductory['rqst_id'] ?></td>
                                <td class=' text-left p-3 border'><?php echo $introductory['name'] ?></td>
                                <td class=' text-left p-3 border'><?php echo $introductory['pnumber'] ?></td>
                                <td class=' text-left p-3 border'><?php echo $introductory['email'] ?></td>
                                <td class=' text-left p-3 border'><?php echo $introductory['phone'] ?></td>
                                <td class=' text-left p-3 border'><?php echo $introductory['purpose'] ?></td>

                            </tr>
                            <?php $count++; endwhile ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th class=" text-bold border p-2" class=' border'>SN</th>
                            <th class=" text-bold border p-2" class=' border'>ID NO.</th>
                            <th class=" text-bold border p-2" class=' border'>REQUEST ID</th>
                            <th class=" text-bold border p-2" class=' border'>NAME</th>
                            <th class=" text-bold border p-2" class=' border'>PASSPORT NUMBER</th>
                            <th class=" text-bold border p-2" class=' border text-center'>E-MAIL</th>
                            <th class=" text-bold border p-2" class=' border text-center'>PHONE</th>
                            <th class=" text-bold border p-2" class=' border text-center'>PURPOSE</th>
                            <!-- <th class=" text-bold border p-2" class=' border text-center'>ACTION</th> -->
                        </tr>
                    </tfoot>
                </table>
            </Card>

        </div>
        <div class=' col-span-4'></div>
    </div>


    <div class="modal" id="myModal">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <Modal hideBackdrop open={open} onClose={handleClose} aria-labelledby="child-modal-title"
                    aria-describedby="child-modal-description">
                    <div>
                        <h2 id="child-modal-title" class=' text-center text-2xl font-bold p-6'>DEFERMENT APPLICATION
                            REQUEST</h2>
                        <hr class=' shadow-3xl' />
                        <div id="child-modal-description">
                            <form method="POST" id="rejectionForm" class="p-4">
                                <center>
                                    <label for="rejectionReason" class="text-lg font-bold center pb-6"> Enter the
                                        reason(s) for Request Rejection</label>
                                </center>
                                <textarea id="rejectionReason" rows="4" name="reason" class="form-control mb-4"
                                    placeholder="This request has been rejected beause..." required></textarea>
                                <!-- <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button -->
                                <center>
                                    <button type="button" class="btn btn-primary dfaDefreject center"
                                        id="submitReject">Send Message</button>
                                </center>
                                <input type="hidden" id="requestId" name="requestId">
                                <input type="hidden" id="requestEmail" name="requestEmail">
                            </form>
                        </div>
                    </div>
                </Modal>

            </div>
        </div>
    </div>



    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/2.0.7/js/dataTables.js"></script>
    <script src="https://cdn.datatables.net/2.0.7/js/dataTables.bootstrap5.js"></script>


    <script>


        $('#example').DataTable();


        $(".dfaDefapprove").click(function (e) {
            e.preventDefault();
            let id = $(this).data('id')

            $.ajax({
                type: "post",
                url: "../../backend/scripts/ajax.php?action=dfaDefapprove&id=" + id,
                success: function (response) {
                    // alert(response);
                    location.reload();
                }
            });

        });

        document.addEventListener('DOMContentLoaded', function () {
            var id = "";
            var reason = "";
            var email = "";
            var myModal = document.getElementById('myModal');
            myModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget; // Button that triggered the modal
                var requestId = button.getAttribute('data-id'); // Extract info from data-* attributes
                var requestEmail = button.getAttribute('data-email');
                var modal = this;
                modal.querySelector('#requestId').value = requestId;
            });

            document.getElementById('rejectionForm').addEventListener('mouseover', function () {
                reason = document.getElementById('rejectionReason').value;
                id = document.getElementById('requestId').value;
                email = document.getElementById('requestEmail').value;
                // alert(id)

            });

            document.getElementById('rejectionReason').addEventListener('focus', function () {
                reason = document.getElementById('rejectionReason').value;
                id = document.getElementById('requestId').value;
                email = document.getElementById('requestEmail').value;
                // alert(id)

            });

            $("#submitReject").on("click", function (e) {
                e.preventDefault();

                $.ajax({
                    url: '../../backend/scripts/ajax.php?action=dfaDefReject&id=' + id + "&reason=" + reason + "&email=" + email,
                    success: function (response) {
                        // if (response == 1) {
                        //     alert('Request rejected and email sent successfully.');
                        //     // $('#myModal').modal('hide');
                        // } else {
                        //     alert(response); // Display the detailed error message from PHP
                        // }



                        alert(response);
                        location.reload();
                    },
                    error: function () {
                        alert('Error in AJAX request.');
                    }
                });
            });
        });
    </script>
</body>

</php>